<?php
require_once __DIR__ . '/../config/database.php';
$db = (new Database())->getConnection();

if (!isset($_GET["reunion_id"])) {
    die("reunion_id manquant");
}

$reunion_id = intval($_GET["reunion_id"]);

header("Content-Type: application/vnd.ms-excel");
header("Content-Disposition: attachment; filename=presence_reunion_$reunion_id.xls");

echo "Nom\tPrénoms\tStatut\n";

$sql = $db->prepare("
    SELECT m.nom, m.prenoms, p.statut
    FROM presences_reunion p
    LEFT JOIN membres m ON m.id = p.membre_id
    WHERE p.reunion_id = ?
    ORDER BY m.nom ASC
");
$sql->execute([$reunion_id]);

while ($row = $sql->fetch(PDO::FETCH_ASSOC)) {
    echo "{$row['nom']}\t{$row['prenoms']}\t{$row['statut']}\n";
}
