<?php
// ======================================================
//   SERVICE CENTRALISÉ DE NOTIFICATIONS
// ======================================================

class NotificationService {
    private $db;
    private $fonnteToken;

    public function __construct($db) {
        $this->db = $db;
        // ⚠️ Mets ton vrai token ici (ne jamais exposer publiquement)
        $this->fonnteToken = "y9WT9ggy54PBNkaF9Csk";
    }

    /**
     * Enregistre une notification dans la table notifications
     */
    private function saveNotification($membreId, $type, $titre, $message, $lien = null) {
        $stmt = $this->db->prepare("
            INSERT INTO notifications (membre_id, type, titre, message, lien, est_lu, date_envoi)
            VALUES (:membre_id, :type, :titre, :message, :lien, 0, NOW())
        ");
        $stmt->execute([
            ':membre_id' => $membreId,
            ':type'      => $type,
            ':titre'     => $titre,
            ':message'   => $message,
            ':lien'      => $lien
        ]);
    }

    /**
     * Envoi WhatsApp via Fonnte
     */
    private function sendWhatsApp($to, $message) {
        $curl = curl_init();

        curl_setopt_array($curl, [
            CURLOPT_URL => "https://api.fonnte.com/send",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => [
                'target'  => $to,
                'message' => $message
            ],
            CURLOPT_HTTPHEADER => [
                "Authorization: {$this->fonnteToken}"
            ]
        ]);

        $response = curl_exec($curl);
        curl_close($curl);

        return $response;
    }

    /**
     * Notification pour une cotisation
     */
    public function notifyCotisation($membre, $montant) {
        $titre   = "Nouvelle cotisation";
        $message = "Bonjour {$membre['nom_complet']}, votre cotisation de {$montant} FCFA a été enregistrée.";
        $this->saveNotification($membre['id'], 'cotisation', $titre, $message);
        $this->sendWhatsApp($membre['telephone'], $message);
    }

    /**
     * Notification pour un arriéré
     */
    public function notifyArriere($membre, $montant) {
        $titre   = "Arriéré détecté";
        $message = "Cher {$membre['nom_complet']}, vous avez un arriéré de {$montant} FCFA à régulariser.";
        $this->saveNotification($membre['id'], 'arriere', $titre, $message);
        $this->sendWhatsApp($membre['telephone'], $message);
    }

    /**
     * Notification pour un rappel
     */
    public function notifyRappel($membre, $texte) {
        $titre   = "Rappel";
        $message = $texte;
        $this->saveNotification($membre['id'], 'rappel', $titre, $message);
        $this->sendWhatsApp($membre['telephone'], $message);
    }
}
